#include <iostream>
#include <string>
#include <sstream>
#include <vector>

using namespace std;

//Definio do tipo Aluno
struct Aluno {
	string matricula;
	string nome;
	string curso; 
	string cpf;
	string tel;
	int idade;
};

/* Prottipos das funes que operam sobre alunos e uma lista 
 * de alunos. 
 */
void adicionar_aluno (Aluno al, vector<Aluno> &alunos);
void remover_aluno (Aluno al, vector<Aluno> &alunos);
void imprimir_aluno (Aluno al);
void imprimir_alunos (vector<Aluno> alunos);

int main () {
	//Cria uma nova lista de alunos
	vector<Aluno> alunos;
	
	//cria novos alunos
	Aluno al, al2; 
	string strtemp;
	
	al.matricula = "1234";
	al.nome = "Chico Mentira";
	al.curso = "Informtica";
	al.cpf = "4454343";
	al.tel = "32323232";
	al.idade = 21;
	
	cout << "Idade: ";
	getline (cin, strtemp);
    stringstream(strtemp) >> al2.idade;
	
	cout << "Matrcula: ";
	getline (cin, al2.matricula);
	cout << "Nome: ";
	getline (cin, al2.nome);
	cout << "Curso: ";
	getline (cin, al2.curso);
	cout << "CPF: ";
	getline (cin, al2.cpf);
	cout << "Telefone: ";
	getline (cin, al2.tel);		
		
	adicionar_aluno (al, alunos);
	adicionar_aluno (al2, alunos);
	
	imprimir_alunos(alunos);
	
	remover_aluno(al, alunos);
	
	imprimir_alunos(alunos);

	
	return 0; 
}

/* Adiciona um novo aluno (al)  lista de alunos (alunos) */
void adicionar_aluno (Aluno al, vector<Aluno> &alunos) {
	alunos.push_back(al);
}

/* Remove o aluno passado no primeiro parmetro (al)
 * da lista de alunos da escola (alunos).
 */ 
void remover_aluno (Aluno al, vector<Aluno> &alunos) {
	 /* uma varivel 'iterator' permite percorrer uma lista
	  * recebe um apontador para um elemento da lista. 
	  */
     vector<Aluno>::iterator it;
     
     /* alunos.begin() - apontador para o incio da lista de alunos. 
      * alunos.end()   - Indica (true) se a lista chegou ao final. 
      * ++it - aponta para o prximo item da lista 
      * (*it) - acessa o elemento da posio atual da lista (
      * 		o aluno atual). 
      */
     for (it = alunos.begin(); it != alunos.end(); ++it) {
         if ((*it).cpf == al.cpf) {
			//'erase' remove o aluno da posio atual da lista. 
            alunos.erase(it);
         }
     }
}

/* Imprime a lista de alunos fornecida */
void imprimir_alunos (vector<Aluno> alunos) {
   vector<Aluno>::iterator  it;
   cout << "Alunos Cadastrados: " << endl; 
   cout << "-------------------" << endl;
   for ( it = alunos.begin(); 
		 it != alunos.end(); ++it) {
		cout << '\t' << "Matrcula: " << (*it).matricula << endl;
		cout << '\t' << "Nome: " << (*it).nome << endl;
		cout << '\t' << "Curso: " << (*it).curso << endl;
		cout << '\t' << "Cpf: " << (*it).cpf << endl;
		cout << '\t' << "Idade: " << (*it).idade << endl;
		cout << '\t' << "Telefone: " << (*it).tel << endl << endl;
   }
}

/* Imprime na tela um aluno em particular*/
void imprimir_aluno (Aluno al) {
	cout << "Nome: " << al.nome << endl;
	cout << "CPF: "  << al.cpf << endl;
	cout << "Matrcula: " << al.matricula << endl;
	cout << "Curso: " << al.curso << endl;
	cout << "Telefone: " << al.tel << endl;
}
