/**
 * Created by eliezio on 19/02/16.
 */
 $(function (){
    $(".quantity").change(function (){
        escreverTotal(calcularTotal());
    });
 });

function converterFloatParaTexto(valor){
    var texto = "R$ " + valor.toFixed(2);
    return texto.replace(".",",");
}

function escreverTotal(texto){
    var total = $("#total");
    total.text(converterFloatParaTexto(texto));
}

function calcularTotal() {
    var total = 0;
    var erro = false;
    var produtos = $(".produto");
    for (var i = 0; i < produtos.length; i++) {
        var $produto = $(produtos[i]);

        var qtdFloat = converterTextoParaFloat($produto.find(".quantity").val());
        var precoFloat = converterTextoParaFloat($produto.find(".price").text());            

        var subtotal=0;
        subtotal = qtdFloat*precoFloat;
        total +=subtotal;

        if (qtdFloat > 10)
            erro=true;
    }
    var $feedback = $("#feedback");
    if(erro)
        $feedback.fadeIn("slow").text("Infelizmente não podemos lhe vender mais de 10 itens por álbum.");
    else
        $feedback.fadeOut("slow");

    return total;
}

function converterTextoParaFloat(texto){
    var numeroLimpo = texto.replace("R$ ","").replace(",",".");
    var numero_float = parseFloat(numeroLimpo);
    return numero_float;
}

function deletarItem(item){
    var linha = $(item).closest("tr");
    linha.fadeOut("5000", function(){
        linha.remove();
    });
    escreverTotal(calcularTotal());   
}

function atualizarPrecos(){
    var produtos = $(".produto");
    for (var i = 0; i < produtos.length; i++) {
        var $produto = $(produtos[i]);

        var $presente = $($produto.find(".gift")[0]);
        var $preco = $($produto.find(".price")[0]);
        if($presente.is())
            var valorAtualizado = converterTextoParaFloat($preco.text()) + 5;
        else
            var valorAtualizado = converterTextoParaFloat($preco.text()) - 5;
        $preco.text(converterFloatParaTexto(valorAtualizado));
    }
    escreverTotal(calcularTotal());
}