/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Annotation
implements Comparable<Annotation>,
Serializable {
    private static final long serialVersionUID = -6515375141284988754L;
    private String type = null;
    private Map<String, String> attributes = null;

    public Annotation(String type) {
        this.setType(type);
        this.setAttributes(null);
    }

    public Annotation(String type, Map<String, String> attributes) {
        this.setType(type);
        this.setAttributes(attributes);
    }

    Annotation(JSONObject jsonObject) {
        String typ = null;
        LinkedHashMap<String, String> attrs = null;
        Iterator it = jsonObject.keys();
        if (it.hasNext()) {
            typ = (String)it.next();
            if (it.hasNext()) {
                this.type = null;
            } else {
                try {
                    JSONObject jo = jsonObject.getJSONObject(typ);
                    attrs = new LinkedHashMap<String, String>();
                    it = jo.keys();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        String value = jo.getString(key);
                        attrs.put(key, value);
                    }
                }
                catch (JSONException jsone) {
                    typ = null;
                    attrs = null;
                }
            }
        }
        this.setType(typ);
        this.setAttributes(attrs);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type == null ? "" : type;
    }

    public Annotation type(String type) {
        this.setType(type);
        return this;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes == null ? new LinkedHashMap() : attributes;
    }

    public Annotation attributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public void addAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public Annotation attribute(String name, String value) {
        this.addAttribute(name, value);
        return this;
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public Integer size() {
        return new Integer(this.attributes.size());
    }

    String asParameterValue() {
        return this.asJSONObject().toString();
    }

    JSONObject asJSONObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(this.type, this.attributes);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }

    @Override
    public int compareTo(Annotation other) {
        if (null == other) {
            return 1;
        }
        if (this == other) {
            return 0;
        }
        int result = this.getType().compareTo(other.getType());
        if (result != 0) {
            return result;
        }
        result = this.size().compareTo(other.size());
        if (result != 0) {
            return result;
        }
        Iterator thisNamesIt = this.sortedNames().iterator();
        Iterator otherNamesIt = other.sortedNames().iterator();
        while (thisNamesIt.hasNext()) {
            String otherValue;
            String otherName;
            String thisName = (String)thisNamesIt.next();
            result = thisName.compareTo(otherName = (String)otherNamesIt.next());
            if (result != 0) {
                return result;
            }
            String thisValue = this.getAttributes().get(thisName);
            result = thisValue.compareTo(otherValue = other.getAttributes().get(otherName));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Annotation)) {
            return false;
        }
        Annotation other = (Annotation)obj;
        return this.getType().equals(other.getType()) && ((Object)this.getAttributes()).equals(other.getAttributes());
    }

    public int hashCode() {
        return 31 * this.type.hashCode() + ((Object)this.attributes).hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Annotation{type='");
        sb.append(this.type).append("', attributes={");
        Iterator<String> nameIt = this.attributes.keySet().iterator();
        while (nameIt.hasNext()) {
            String name = nameIt.next();
            String value = this.attributes.get(name);
            sb.append('\'').append(name).append("'='").append(value).append('\'');
            if (!nameIt.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}}");
        return sb.toString();
    }

    private SortedSet<String> sortedNames() {
        TreeSet<String> names = new TreeSet<String>();
        names.addAll(this.getAttributes().keySet());
        return names;
    }

    @Override
    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((Annotation)x0);
    }
}

