package br.edu.ifrn.objectstream;



import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.Vector;


public class PrincipalObjectStream {


	ContatoObjectStream ObjContato = new ContatoObjectStream();
	
	   ArrayList<Contato> vetorContato = new ArrayList<>();

	Contato contato;
	
	public static void main(String[] args) {
		
			PrincipalObjectStream objStream = new PrincipalObjectStream();
			objStream.execMenu();
	}
	
	private void execMenu() {
		
		recuperar();
		
		int op = 0;
		
		while (true) {
			Scanner sc = new Scanner(System.in);
			System.out.println("1 - Cadastrar uma conta");
			System.out.println("2 - Consultar uma conta");
			System.out.println("9 - Sair");
			System.out.println("Entre com uma opção: ");
			op = sc.nextInt();
			try {
				switch (op) {
				case 1:
					execCadastrar();
					break;
				case 2:
					execConsulta(vetorContato);
					break;
				case 9:
					sair(vetorContato);
					
				default:
					System.out.println("Opção inválida.");
				}
			}
			catch (Exception e) {
				System.out.println(e.getMessage());
			}
		}
	}
		
	private void sair(ArrayList<Contato> vetorContato) {
		
		ObjContato.gravar(vetorContato);
		System.exit(0);
	}

	public void execConsulta(ArrayList<Contato> vetorContato) {
		
			this.ObjContato.imprimir(vetorContato);
	}
	
	public void execCadastrar() {
			
			contato = new Contato();
			
			// Para permitir que seja feita a leitura de um nome composto
			Scanner sc = new Scanner(System.in);//.useDelimiter("\r\n");
			
			System.out.println("Entre com o nome: ");
			contato.setNome(sc.nextLine());
			
			System.out.println("Entre com telefone: ");
			contato.setTelefone(sc.nextLine());
			
			System.out.println("Entre com a idade : ");
			contato.setIdade(sc.nextLine());

			vetorContato.add(contato);
		
		}
	
		public void recuperar() {
		
		try {

			ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream("contato.dat")));
			
			// lê a quantidade a partir do arquivo
		    int quantidade = ois.readInt();
			
			for (int i = 0; i < quantidade; i++) {
				
				Contato cont = new Contato();
				cont  = (Contato) ois.readObject();
				
				System.out.println(cont.getNome());
				vetorContato.add(cont);
			}
			
			ois.close();
			
		} catch (FileNotFoundException fileEx) {

			fileEx.getMessage();
			 
		} catch (ClassNotFoundException | IOException classEx) {
			
			classEx.getMessage();

		}
	}
}
