package br.edu.ifrn.objectstream;



import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;

public class ContatoObjectStream implements Serializable, InterfaceContato{
	
	// para que o objeto seja serializado precisamos criar este número
	private static final long serialVersionUID = 1L;

	/*este atributo será salvo no arquivo de forma explicita por meio do método
	writeInt()*/
	private transient int quantidade = 0;

        @Override
	public int getQuantidade() {
		return this.quantidade;
	}

        @Override
	public void setQuantidade(int quantidade) {
		this.quantidade = quantidade;
	}

        @Override
	public void imprimir(ArrayList<Contato> vetorContato) {
		
		for (int i = 0; i < vetorContato.size(); i++) {
			
			System.out.println("******************************");
			
			System.out.println("Nome : "+vetorContato.get(i).getNome());
			System.out.println("Fone : "+vetorContato.get(i).getTelefone());
			System.out.println("Idade : "+vetorContato.get(i).getIdade());
			
			System.out.println(" ");
			System.out.println("******************************");
		}
	}

        @Override
	public void gravar(ArrayList<Contato> vetorContato){
		try {
			/*
			 * Quando usamos ObjectOutputStream não podemos utilizar o modo
			 * append. Na gravação não apresenta erro porém na leitura é lançada
			 * a exceção Java.io.StreamCorruptedException.
			 */
			
			 ObjectOutputStream obj = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream("contato.dat")));
			 
			 // grava a quantidade já gravada mais uma unidade
		     obj.writeInt(vetorContato.size());
			
			 // atualiza o atributo
		     setQuantidade(vetorContato.size());
			
		     for (int i = 0; i < vetorContato.size(); i++) {
		    	 obj.writeObject(vetorContato.get(i));
		     }
			
			 obj.flush();
			 obj.close();
		
			
			
		} catch (FileNotFoundException fileEx) {
		
			fileEx.getMessage();
			
		} catch (IOException ioEx) {
			
			ioEx.getMessage();
		} 		
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}
}
