/*
 * Decompiled with CFR 0.152.
 */
import java.awt.EventQueue;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Scanner;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingWorker;

public class Console
extends JFrame
implements KeyListener {
    private JTextField prompt;
    private JTextArea log;
    private final PipedInputStream inPipe = new PipedInputStream();
    private final PipedInputStream outPipe = new PipedInputStream();
    private PrintWriter inWriter;

    public Console(String title) {
        super(title);
        System.setIn(this.inPipe);
        try {
            System.setOut(new PrintStream(new PipedOutputStream(this.outPipe), true));
            this.inWriter = new PrintWriter(new PipedOutputStream(this.inPipe), true);
        }
        catch (IOException e) {
            System.out.println("Error: " + e);
            return;
        }
        JPanel p = new JPanel();
        p.setLayout(null);
        this.log = new JTextArea();
        this.log.setEditable(false);
        this.log.setBounds(10, 10, 345, 250);
        p.add(this.log);
        this.prompt = new JTextField();
        this.prompt.setBounds(10, 270, 356, 80);
        this.prompt.addKeyListener(this);
        p.add(this.prompt);
        this.getContentPane().add(p);
        this.setVisible(true);
        this.setSize(392, 400);
        this.setLocationRelativeTo(null);
        new SwingWorker<Void, String>(){

            @Override
            protected Void doInBackground() throws Exception {
                Scanner s = new Scanner(Console.this.outPipe);
                while (s.hasNextLine()) {
                    String line = s.nextLine();
                    this.publish(line);
                }
                return null;
            }

            @Override
            protected void process(List<String> chunks) {
                for (String line : chunks) {
                    if (line.length() < 1) continue;
                    Console.this.log.append(String.valueOf(line.trim()) + "\n");
                }
            }
        }.execute();
    }

    public void execute() {
        String text = this.prompt.getText();
        this.prompt.setText("");
        System.out.println(text);
        this.inWriter.print(text.trim().replaceAll("\r\n", ""));
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.execute();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.execute();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.execute();
        }
    }

    public static void setConsole(final String title, final String codigo) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Console(title);
                System.out.println("somewhat");
                Execucao.executar(codigo);
            }
        });
    }

    public static void main(String ... args) {
        Console.setConsole("teste", "");
    }
}

