/*
 * Decompiled with CFR 0.152.
 */
package br.edu.ifrn.potigol;

import br.edu.ifrn.potigol.potigolBaseListener;
import br.edu.ifrn.potigol.potigolParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.antlr.v4.runtime.tree.TerminalNode;

public class Listener
extends potigolBaseListener {
    private int num = 0;
    private final ParseTreeProperty<String> values = new ParseTreeProperty();
    private String saida = "";
    private static List<String> scalawords = Arrays.asList("type", "yield", "lazy", "override", "def", "with", "val", "var", "false", "true", "sealed", "abstract", "private", "trait", "object", "null", "if", "for", "while", "throw", "finally", "protected", "extends", "import", "final", "return", "else", "break", "new", "catch", "super", "class", "case", "package", "default", "try", "this", "match", "continue", "throws");

    private String nextVar() {
        ++this.num;
        return "$a" + this.num;
    }

    private void setValue(ParseTree node, String value) {
        this.values.put(node, (Object)value);
    }

    private String getValue(ParseTree node) {
        return (String)this.values.get(node);
    }

    private String escapeID(String id) {
        if (scalawords.contains(id)) {
            return "`" + id + "`";
        }
        return id;
    }

    @Override
    public void exitChar(potigolParser.CharContext ctx) {
        String s = ctx.CHAR().getText();
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitGet_vetor(potigolParser.Get_vetorContext ctx) {
        String id = this.getValue((ParseTree)ctx.expr(0));
        String indice = this.getValue((ParseTree)ctx.expr(1));
        String s = String.valueOf(id) + ".get(" + indice + ")";
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitDcl1(potigolParser.Dcl1Context ctx) {
        this.setValue((ParseTree)ctx, this.getValue((ParseTree)ctx.children.get(0)));
    }

    @Override
    public void exitSet_vetor(potigolParser.Set_vetorContext ctx) {
        String id = this.getValue((ParseTree)ctx.expr(0));
        String indice = this.getValue((ParseTree)ctx.expr(1));
        String exp = this.getValue((ParseTree)ctx.expr(2));
        String s = String.valueOf(id) + "(" + indice + " -1) =" + exp;
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitLambda(potigolParser.LambdaContext ctx) {
        String param = this.getValue((ParseTree)ctx.dcl1());
        String corpo = "";
        for (potigolParser.InstContext i : ctx.inst()) {
            corpo = String.valueOf(corpo) + this.getValue((ParseTree)i) + "\n";
        }
        String s = " (" + param + ") => {" + corpo + " }";
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitTipo_generico(potigolParser.Tipo_genericoContext ctx) {
        String id = this.getValue((ParseTree)ctx.ID());
        String tipo = this.getValue((ParseTree)ctx.tipo());
        String s = String.valueOf(id) + "[" + tipo + "]";
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitTipo_funcao(potigolParser.Tipo_funcaoContext ctx) {
        String esq = this.getValue((ParseTree)ctx.tipo(0));
        String dir = this.getValue((ParseTree)ctx.tipo(1));
        String s = "(" + esq + " => " + dir + ")";
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitTipo2(potigolParser.Tipo2Context ctx) {
        String s = "";
        for (potigolParser.TipoContext tipo : ctx.tipo()) {
            s = String.valueOf(s) + ", " + this.getValue((ParseTree)tipo);
        }
        s = s.replaceFirst(", ", " ");
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitTipo_tupla(potigolParser.Tipo_tuplaContext ctx) {
        String s = "(" + this.getValue((ParseTree)ctx.tipo2()) + ")";
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitCons(potigolParser.ConsContext ctx) {
        String a = this.getValue((ParseTree)ctx.expr(0));
        String as = this.getValue((ParseTree)ctx.expr(1));
        String s = "(" + a + "::" + as + ")";
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitExpoente(potigolParser.ExpoenteContext ctx) {
        String base = this.getValue((ParseTree)ctx.expr(0));
        String exp = this.getValue((ParseTree)ctx.expr(1));
        String s = "( Math.pow(" + base + ", " + exp + ") )";
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitCaso(potigolParser.CasoContext ctx) {
        String exp = this.getValue((ParseTree)ctx.expr(0));
        String cond = ctx.expr().size() > 1 ? "if " + this.getValue((ParseTree)ctx.expr(1)) : "";
        String exps = this.getValue((ParseTree)ctx.exprlist());
        String s = "case " + exp + " " + cond + " =>" + exps;
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitEscolha(potigolParser.EscolhaContext ctx) {
        String exp = this.getValue((ParseTree)ctx.expr());
        String s = "(" + exp + ") match {\n";
        for (potigolParser.CasoContext caso : ctx.caso()) {
            s = String.valueOf(s) + "  " + this.getValue((ParseTree)caso) + "\n";
        }
        s = String.valueOf(s) + "}";
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitFormato(potigolParser.FormatoContext ctx) {
        String exp1 = this.getValue((ParseTree)ctx.expr(0));
        String exp2 = this.getValue((ParseTree)ctx.expr(1));
        String s = "(" + exp1 + ").formato(" + exp2 + ")";
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitAlias(potigolParser.AliasContext ctx) {
        String id = ctx.ID().getText();
        String tipo = this.getValue((ParseTree)ctx.tipo());
        String s = "type " + this.escapeID(id) + " = " + tipo;
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitClasse(potigolParser.ClasseContext ctx) {
        String id = ctx.ID().getText();
        String s = "case class " + this.escapeID(id) + " {\n";
        int i = 2;
        while (i < ctx.children.size() - 1) {
            ParseTree d = (ParseTree)ctx.children.get(i);
            s = String.valueOf(s) + "  " + this.getValue(d) + "\n";
            ++i;
        }
        s = String.valueOf(s) + "}";
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void enterProg(potigolParser.ProgContext ctx) {
        this.saida = String.valueOf(this.saida) + "import br.edu.ifrn.potigol.potigolutil._\n";
    }

    @Override
    public void exitAtrib_multipla(potigolParser.Atrib_multiplaContext ctx) {
        String id = this.getValue((ParseTree)ctx.id2());
        String[] ids = id.split(", ");
        String exp = this.getValue((ParseTree)ctx.expr2());
        String[] exps = exp.split(", ");
        String[] aux = new String[ids.length];
        String s = "";
        int i = 0;
        while (i < ids.length) {
            aux[i] = this.nextVar();
            s = String.valueOf(s) + "val " + aux[i] + " = " + exps[i] + "\n";
            ++i;
        }
        i = 0;
        while (i < ids.length) {
            s = String.valueOf(s) + ids[i] + " = " + aux[i] + "\n";
            ++i;
        }
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitAtrib_simples(potigolParser.Atrib_simplesContext ctx) {
        String id = this.getValue((ParseTree)ctx.id1());
        String[] ids = id.split(", ");
        String exp = this.getValue((ParseTree)ctx.expr());
        String var = this.nextVar();
        String s = "def " + var + " = " + exp + "\n";
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            s = String.valueOf(s) + i + " = " + var + " \n";
            ++n2;
        }
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitChamada_funcao(potigolParser.Chamada_funcaoContext ctx) {
        this.setValue((ParseTree)ctx, String.valueOf(this.getValue((ParseTree)ctx.expr())) + "(" + this.getValue((ParseTree)ctx.expr1()) + ")");
    }

    @Override
    public void exitChamada_metodo(potigolParser.Chamada_metodoContext ctx) {
        String exp = this.getValue((ParseTree)ctx.expr());
        String id = this.getValue((ParseTree)ctx.ID());
        String exp1 = this.getValue((ParseTree)ctx.expr1());
        String s = String.valueOf(exp) + "." + id;
        if (exp1 != null) {
            s = String.valueOf(s) + "(" + exp1 + ")";
        }
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitComparacao(potigolParser.ComparacaoContext ctx) {
        String exp1 = this.getValue((ParseTree)ctx.expr(0));
        String exp2 = this.getValue((ParseTree)ctx.expr(1));
        String op = ctx.getChild(1).getText();
        if ("<>".equals(op)) {
            op = "!=";
        }
        this.setValue((ParseTree)ctx, "(" + exp1 + op + exp2 + ")");
    }

    @Override
    public void exitDcl(potigolParser.DclContext ctx) {
        String id = this.getValue((ParseTree)ctx.id1());
        String tipo = this.getValue((ParseTree)ctx.tipo());
        String s = String.valueOf(id.replaceAll(", ", ": " + tipo + ", ")) + ": " + tipo;
        if (ctx.parent.getRuleIndex() == 6) {
            s = "var " + s;
        }
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitDcls(potigolParser.DclsContext ctx) {
        ArrayList<String> a = new ArrayList<String>();
        for (potigolParser.DclContext dcl : ctx.dcl()) {
            a.add(this.getValue((ParseTree)dcl));
        }
        this.ids2String((RuleContext)ctx, a);
    }

    @Override
    public void exitDecl(potigolParser.DeclContext ctx) {
        String s = "";
        for (ParseTree i : ctx.children) {
            s = String.valueOf(s) + "\n" + this.getValue(i);
        }
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitDecl_var_multipla(potigolParser.Decl_var_multiplaContext ctx) {
        String id = this.getValue((ParseTree)ctx.id2());
        String[] ids = id.split(", ");
        String exp = this.getValue((ParseTree)ctx.expr2());
        String[] exps = exp.split(", ");
        String s = "";
        int i = 0;
        while (i < ids.length) {
            s = String.valueOf(s) + "var " + ids[i] + " = " + exps[i] + "\n";
            ++i;
        }
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitDecl_var_simples(potigolParser.Decl_var_simplesContext ctx) {
        String id = this.getValue((ParseTree)ctx.id1());
        String exp = this.getValue((ParseTree)ctx.expr());
        this.setValue((ParseTree)ctx, "var " + id + " = " + exp);
    }

    @Override
    public void exitDef_funcao(potigolParser.Def_funcaoContext ctx) {
        String s = "def " + this.getValue((ParseTree)ctx.ID()) + "(" + this.getValue((ParseTree)ctx.dcls()) + ")";
        String tipo = this.getValue((ParseTree)ctx.tipo());
        if (tipo != null) {
            s = String.valueOf(s) + ": " + tipo;
        }
        s = String.valueOf(s) + " = {" + this.getValue((ParseTree)ctx.expr()) + "}";
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitDef_funcao_corpo(potigolParser.Def_funcao_corpoContext ctx) {
        String s = "def " + this.getValue((ParseTree)ctx.ID()) + "(" + this.getValue((ParseTree)ctx.dcls()) + ")";
        String tipo = this.getValue((ParseTree)ctx.tipo());
        if (tipo != null) {
            s = String.valueOf(s) + ": " + tipo;
        }
        s = String.valueOf(s) + "= {" + this.getValue((ParseTree)ctx.exprlist()) + "}\n";
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitE_logico(potigolParser.E_logicoContext ctx) {
        String exp1 = this.getValue((ParseTree)ctx.expr(0));
        String exp2 = this.getValue((ParseTree)ctx.expr(1));
        this.setValue((ParseTree)ctx, "(" + exp1 + " && " + exp2 + ")");
    }

    @Override
    public void exitEnquanto(potigolParser.EnquantoContext ctx) {
        String exp = this.getValue((ParseTree)ctx.expr());
        String exprlist = this.getValue((ParseTree)ctx.exprlist());
        String s = "while (" + exp + ") {" + exprlist + "}";
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitEscreva(potigolParser.EscrevaContext ctx) {
        this.setValue((ParseTree)ctx, "escreva(" + this.getValue((ParseTree)ctx.expr()) + ")");
    }

    @Override
    public void exitEveryRule(ParserRuleContext ctx) {
        if (this.getValue((ParseTree)ctx) == null) {
            this.setValue((ParseTree)ctx, "Regra_" + ctx.getRuleIndex());
        }
    }

    @Override
    public void exitExpr1(potigolParser.Expr1Context ctx) {
        ArrayList<String> a = new ArrayList<String>();
        for (potigolParser.ExprContext exp : ctx.expr()) {
            a.add(this.getValue((ParseTree)exp));
        }
        this.ids2String((RuleContext)ctx, a);
    }

    @Override
    public void exitExpr2(potigolParser.Expr2Context ctx) {
        ArrayList<String> a = new ArrayList<String>();
        for (potigolParser.ExprContext exp : ctx.expr()) {
            a.add(this.getValue((ParseTree)exp));
        }
        this.ids2String((RuleContext)ctx, a);
    }

    @Override
    public void exitExprlist(potigolParser.ExprlistContext ctx) {
        String s = "\n";
        for (potigolParser.InstContext i : ctx.inst()) {
            s = String.valueOf(s) + "  " + this.getValue((ParseTree)i) + "\n";
        }
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitFaixa(potigolParser.FaixaContext ctx) {
        String s;
        String id = this.getValue((ParseTree)ctx.ID());
        switch (ctx.expr().size()) {
            case 1: {
                s = this.getValue((ParseTree)ctx.expr(0));
                break;
            }
            case 2: {
                s = String.valueOf(this.getValue((ParseTree)ctx.expr(0))) + " to " + this.getValue((ParseTree)ctx.expr(1));
                break;
            }
            default: {
                s = String.valueOf(this.getValue((ParseTree)ctx.expr(0))) + " to " + this.getValue((ParseTree)ctx.expr(1)) + " by " + this.getValue((ParseTree)ctx.expr(2));
            }
        }
        this.setValue((ParseTree)ctx, String.valueOf(id) + " <- " + s);
    }

    @Override
    public void exitFaixas(potigolParser.FaixasContext ctx) {
        String s = "";
        for (potigolParser.FaixaContext f : ctx.faixa()) {
            s = f != ctx.faixa(0) ? String.valueOf(s) + "; " + this.getValue((ParseTree)f) : String.valueOf(s) + this.getValue((ParseTree)f);
        }
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitFalso(potigolParser.FalsoContext ctx) {
        this.setValue((ParseTree)ctx, "false");
    }

    @Override
    public void exitId(potigolParser.IdContext ctx) {
        this.setValue((ParseTree)ctx, this.escapeID(ctx.getText()));
    }

    @Override
    public void exitId1(potigolParser.Id1Context ctx) {
        ArrayList<String> a = new ArrayList<String>();
        for (TerminalNode id : ctx.ID()) {
            a.add(this.getValue((ParseTree)id));
        }
        this.ids2String((RuleContext)ctx, a);
    }

    @Override
    public void exitId2(potigolParser.Id2Context ctx) {
        ArrayList<String> a = new ArrayList<String>();
        for (TerminalNode id : ctx.ID()) {
            a.add(this.getValue((ParseTree)id));
        }
        this.ids2String((RuleContext)ctx, a);
    }

    @Override
    public void exitImprima(potigolParser.ImprimaContext ctx) {
        this.setValue((ParseTree)ctx, "imprima(" + this.getValue((ParseTree)ctx.expr()) + ")");
    }

    @Override
    public void exitInst(potigolParser.InstContext ctx) {
        String s = "";
        for (ParseTree i : ctx.children) {
            s = String.valueOf(s) + this.getValue(i) + "\n";
        }
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitInteiro(potigolParser.InteiroContext ctx) {
        this.setValue((ParseTree)ctx, ctx.getText());
    }

    @Override
    public void exitLista(potigolParser.ListaContext ctx) {
        String exp = this.getValue((ParseTree)ctx.expr1());
        this.setValue((ParseTree)ctx, "Lista(List(" + exp + "))");
    }

    @Override
    public void exitMais_menos_unario(potigolParser.Mais_menos_unarioContext ctx) {
        String exp1 = this.getValue((ParseTree)ctx.expr());
        String op = ctx.getChild(0).getText();
        this.setValue((ParseTree)ctx, "(" + op + exp1 + ")");
    }

    @Override
    public void exitMult_div(potigolParser.Mult_divContext ctx) {
        String exp1 = this.getValue((ParseTree)ctx.expr(0));
        String exp2 = this.getValue((ParseTree)ctx.expr(1));
        String op = ctx.getChild(1).getText();
        if (op.equals("mod")) {
            op = "%";
        }
        this.setValue((ParseTree)ctx, "(" + exp1 + " " + op + " " + exp2 + ")");
    }

    @Override
    public void exitNao_logico(potigolParser.Nao_logicoContext ctx) {
        String exp = this.getValue((ParseTree)ctx.expr());
        this.setValue((ParseTree)ctx, "(!" + exp + ")");
    }

    @Override
    public void exitOu_logico(potigolParser.Ou_logicoContext ctx) {
        String exp1 = this.getValue((ParseTree)ctx.expr(0));
        String exp2 = this.getValue((ParseTree)ctx.expr(1));
        this.setValue((ParseTree)ctx, "(" + exp1 + " || " + exp2 + ")");
    }

    @Override
    public void exitPara_faca(potigolParser.Para_facaContext ctx) {
        String faixas = this.getValue((ParseTree)ctx.faixas());
        String se = this.getValue((ParseTree)ctx.expr());
        String faca = this.getValue((ParseTree)ctx.exprlist());
        String s = "for(" + faixas;
        if (se != null) {
            s = String.valueOf(s) + " if " + se;
        }
        s = String.valueOf(s) + ") {" + faca + "}";
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitPara_gere(potigolParser.Para_gereContext ctx) {
        String faixas = this.getValue((ParseTree)ctx.faixas());
        String se = this.getValue((ParseTree)ctx.expr());
        String faca = this.getValue((ParseTree)ctx.exprlist());
        String s = "Lista((for(" + faixas;
        if (se != null) {
            s = String.valueOf(s) + " if " + se;
        }
        s = String.valueOf(s) + ")  yield {" + faca + "}).toList)";
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitParen(potigolParser.ParenContext ctx) {
        String exp = this.getValue((ParseTree)ctx.expr());
        this.setValue((ParseTree)ctx, "(" + exp + ")");
    }

    @Override
    public void exitProg(potigolParser.ProgContext ctx) {
        for (potigolParser.InstContext i : ctx.inst()) {
            this.saida = String.valueOf(this.saida) + this.getValue((ParseTree)i);
        }
        this.saida = String.valueOf(this.saida) + "\n";
        this.setValue((ParseTree)ctx, this.saida);
    }

    @Override
    public void exitReal(potigolParser.RealContext ctx) {
        this.setValue((ParseTree)ctx, ctx.getText());
    }

    @Override
    public void exitSe(potigolParser.SeContext ctx) {
        ArrayList<String> conds = new ArrayList<String>();
        for (potigolParser.ExprContext c : ctx.expr()) {
            conds.add(this.getValue((ParseTree)c));
        }
        ArrayList<String> entaos = new ArrayList<String>();
        for (potigolParser.ExprlistContext c : ctx.exprlist()) {
            entaos.add(this.getValue((ParseTree)c));
        }
        String s = "";
        int i = 0;
        while (i < conds.size()) {
            s = String.valueOf(s) + "if(" + (String)conds.get(i) + ") {" + (String)entaos.get(i) + "}";
            if (i < entaos.size() - 1) {
                s = String.valueOf(s) + " else ";
            }
            ++i;
        }
        if (entaos.size() > conds.size()) {
            s = String.valueOf(s) + "{" + (String)entaos.get(entaos.size() - 1) + "}";
        }
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitSoma_sub(potigolParser.Soma_subContext ctx) {
        String exp1 = this.getValue((ParseTree)ctx.expr(0));
        String exp2 = this.getValue((ParseTree)ctx.expr(1));
        String op = ctx.getChild(1).getText();
        this.setValue((ParseTree)ctx, "(" + exp1 + op + exp2 + ")");
    }

    @Override
    public void exitTexto(potigolParser.TextoContext ctx) {
        String s = ctx.getText().replace("{", "${");
        if (s.contains("\n")) {
            s = "\"\"" + s + "\"\".stripMargin('|')";
        }
        if (s.contains("{")) {
            s = "s" + s;
        }
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitTipo_simples(potigolParser.Tipo_simplesContext ctx) {
        this.setValue((ParseTree)ctx, this.getValue((ParseTree)ctx.ID()));
    }

    @Override
    public void exitTupla(potigolParser.TuplaContext ctx) {
        String exp = this.getValue((ParseTree)ctx.expr2());
        this.setValue((ParseTree)ctx, "(" + exp + ")");
    }

    @Override
    public void exitValor_multiplo(potigolParser.Valor_multiploContext ctx) {
        String id = this.getValue((ParseTree)ctx.id2());
        String[] ids = id.split(", ");
        String exp = this.getValue((ParseTree)ctx.expr2());
        String[] exps = exp.split(", ");
        String s = "";
        int i = 0;
        while (i < ids.length) {
            s = String.valueOf(s) + "val " + ids[i] + " = " + exps[i] + "\n";
            ++i;
        }
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void exitValor_simples(potigolParser.Valor_simplesContext ctx) {
        String id = this.getValue((ParseTree)ctx.id1());
        String exp = this.getValue((ParseTree)ctx.expr());
        this.setValue((ParseTree)ctx, "val " + id + " = " + exp);
    }

    @Override
    public void exitVerdadeiro(potigolParser.VerdadeiroContext ctx) {
        this.setValue((ParseTree)ctx, "true");
    }

    private void ids2String(RuleContext ctx, List<String> a) {
        String s = "";
        if (a.size() > 0) {
            s = a.get(0);
        }
        int i = 1;
        while (i < a.size()) {
            s = String.valueOf(s) + ", " + a.get(i);
            ++i;
        }
        this.setValue((ParseTree)ctx, s);
    }

    @Override
    public void visitTerminal(TerminalNode node) {
        String s;
        switch (node.getSymbol().getType()) {
            case 55: {
                s = this.escapeID(node.getText());
                break;
            }
            default: {
                s = node.getText();
            }
        }
        this.setValue((ParseTree)node, s);
    }

    public String getSaida() {
        return this.saida.replaceAll("\n\n", "\n").replaceAll("\n\n", "\n");
    }
}

