/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.atn;

import java.io.InvalidClassException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.antlr.v4.runtime.atn.ATN;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.atn.ATNType;
import org.antlr.v4.runtime.atn.ActionTransition;
import org.antlr.v4.runtime.atn.AtomTransition;
import org.antlr.v4.runtime.atn.BasicBlockStartState;
import org.antlr.v4.runtime.atn.BasicState;
import org.antlr.v4.runtime.atn.BlockEndState;
import org.antlr.v4.runtime.atn.BlockStartState;
import org.antlr.v4.runtime.atn.DecisionState;
import org.antlr.v4.runtime.atn.EpsilonTransition;
import org.antlr.v4.runtime.atn.LoopEndState;
import org.antlr.v4.runtime.atn.NotSetTransition;
import org.antlr.v4.runtime.atn.PlusBlockStartState;
import org.antlr.v4.runtime.atn.PlusLoopbackState;
import org.antlr.v4.runtime.atn.PredicateTransition;
import org.antlr.v4.runtime.atn.PredictionContext;
import org.antlr.v4.runtime.atn.PredictionContextCache;
import org.antlr.v4.runtime.atn.RangeTransition;
import org.antlr.v4.runtime.atn.RuleStartState;
import org.antlr.v4.runtime.atn.RuleStopState;
import org.antlr.v4.runtime.atn.RuleTransition;
import org.antlr.v4.runtime.atn.SetTransition;
import org.antlr.v4.runtime.atn.StarBlockStartState;
import org.antlr.v4.runtime.atn.StarLoopEntryState;
import org.antlr.v4.runtime.atn.StarLoopbackState;
import org.antlr.v4.runtime.atn.TokensStartState;
import org.antlr.v4.runtime.atn.Transition;
import org.antlr.v4.runtime.atn.WildcardTransition;
import org.antlr.v4.runtime.dfa.DFAState;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.misc.Pair;

public abstract class ATNSimulator {
    public static final int SERIALIZED_VERSION = 3;
    public static final UUID SERIALIZED_UUID = UUID.fromString("33761B2D-78BB-4A43-8B0B-4F5BEE8AACF3");
    @NotNull
    public static final DFAState ERROR = new DFAState(new ATNConfigSet());
    @NotNull
    public final ATN atn;
    protected final PredictionContextCache sharedContextCache;

    public ATNSimulator(@NotNull ATN atn, @NotNull PredictionContextCache sharedContextCache) {
        this.atn = atn;
        this.sharedContextCache = sharedContextCache;
    }

    public abstract void reset();

    public PredictionContextCache getSharedContextCache() {
        return this.sharedContextCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PredictionContext getCachedContext(PredictionContext context) {
        if (this.sharedContextCache == null) {
            return context;
        }
        PredictionContextCache predictionContextCache = this.sharedContextCache;
        synchronized (predictionContextCache) {
            IdentityHashMap<PredictionContext, PredictionContext> visited = new IdentityHashMap<PredictionContext, PredictionContext>();
            return PredictionContext.getCachedContext(context, this.sharedContextCache, visited);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ATN deserialize(@NotNull char[] data) {
        void var11_19;
        int version;
        data = (char[])data.clone();
        for (int i = 1; i < data.length; ++i) {
            data[i] = (char)(data[i] - 2);
        }
        int p = 0;
        if ((version = ATNSimulator.toInt(data[p++])) != SERIALIZED_VERSION) {
            String reason = String.format(Locale.getDefault(), "Could not deserialize ATN with version %d (expected %d).", version, SERIALIZED_VERSION);
            throw new UnsupportedOperationException(new InvalidClassException(ATN.class.getName(), reason));
        }
        UUID uuid = ATNSimulator.toUUID(data, p);
        p += 8;
        if (!uuid.equals(SERIALIZED_UUID)) {
            String reason = String.format(Locale.getDefault(), "Could not deserialize ATN with UUID %s (expected %s).", uuid, SERIALIZED_UUID);
            throw new UnsupportedOperationException(new InvalidClassException(ATN.class.getName(), reason));
        }
        ATNType grammarType = ATNType.values()[ATNSimulator.toInt(data[p++])];
        int maxTokenType = ATNSimulator.toInt(data[p++]);
        ATN atn = new ATN(grammarType, maxTokenType);
        ArrayList<Pair<LoopEndState, Integer>> loopBackStateNumbers = new ArrayList<Pair<LoopEndState, Integer>>();
        ArrayList<Pair<BlockStartState, Integer>> endStateNumbers = new ArrayList<Pair<BlockStartState, Integer>>();
        int nstates = ATNSimulator.toInt(data[p++]);
        for (int i = 0; i < nstates; ++i) {
            int ruleIndex;
            int n;
            if ((n = ATNSimulator.toInt(data[p++])) == 0) {
                atn.addState(null);
                continue;
            }
            if ((ruleIndex = ATNSimulator.toInt(data[p++])) == 65535) {
                ruleIndex = -1;
            }
            ATNState s = ATNSimulator.stateFactory(n, ruleIndex);
            if (n == 12) {
                int loopBackStateNumber = ATNSimulator.toInt(data[p++]);
                loopBackStateNumbers.add(new Pair<LoopEndState, Integer>((LoopEndState)s, loopBackStateNumber));
            } else if (s instanceof BlockStartState) {
                int endStateNumber = ATNSimulator.toInt(data[p++]);
                endStateNumbers.add(new Pair<BlockStartState, Integer>((BlockStartState)s, endStateNumber));
            }
            atn.addState(s);
        }
        for (Pair pair : loopBackStateNumbers) {
            ((LoopEndState)pair.a).loopBackState = atn.states.get((Integer)pair.b);
        }
        for (Pair pair : endStateNumbers) {
            ((BlockStartState)pair.a).endState = (BlockEndState)atn.states.get((Integer)pair.b);
        }
        int numNonGreedyStates = ATNSimulator.toInt(data[p++]);
        boolean bl = false;
        while (var11_19 < numNonGreedyStates) {
            int stateNumber = ATNSimulator.toInt(data[p++]);
            ((DecisionState)atn.states.get((int)stateNumber)).nonGreedy = true;
            ++var11_19;
        }
        int n = ATNSimulator.toInt(data[p++]);
        if (atn.grammarType == ATNType.LEXER) {
            atn.ruleToTokenType = new int[n];
            atn.ruleToActionIndex = new int[n];
        }
        atn.ruleToStartState = new RuleStartState[n];
        for (int i = 0; i < n; ++i) {
            int actionIndex;
            int tokenType;
            RuleStartState startState;
            int s = ATNSimulator.toInt(data[p++]);
            atn.ruleToStartState[i] = startState = (RuleStartState)atn.states.get(s);
            if (atn.grammarType != ATNType.LEXER) continue;
            if ((tokenType = ATNSimulator.toInt(data[p++])) == 65535) {
                tokenType = -1;
            }
            atn.ruleToTokenType[i] = tokenType;
            if ((actionIndex = ATNSimulator.toInt(data[p++])) == 65535) {
                actionIndex = -1;
            }
            atn.ruleToActionIndex[i] = actionIndex;
        }
        atn.ruleToStopState = new RuleStopState[n];
        for (ATNState state : atn.states) {
            RuleStopState stopState;
            if (!(state instanceof RuleStopState)) continue;
            atn.ruleToStopState[state.ruleIndex] = stopState = (RuleStopState)state;
            atn.ruleToStartState[state.ruleIndex].stopState = stopState;
        }
        int nmodes = ATNSimulator.toInt(data[p++]);
        for (int i = 0; i < nmodes; ++i) {
            int s = ATNSimulator.toInt(data[p++]);
            atn.modeToStartState.add((TokensStartState)atn.states.get(s));
        }
        ArrayList<IntervalSet> sets = new ArrayList<IntervalSet>();
        int nsets = ATNSimulator.toInt(data[p++]);
        for (int i = 0; i < nsets; ++i) {
            boolean containsEof;
            int nintervals = ATNSimulator.toInt(data[p]);
            IntervalSet set = new IntervalSet(new int[0]);
            sets.add(set);
            int n2 = ++p;
            ++p;
            boolean bl2 = containsEof = ATNSimulator.toInt(data[n2]) != 0;
            if (containsEof) {
                set.add(-1);
            }
            for (int j = 0; j < nintervals; ++j) {
                set.add(ATNSimulator.toInt(data[p]), ATNSimulator.toInt(data[p + 1]));
                p += 2;
            }
        }
        int nedges = ATNSimulator.toInt(data[p++]);
        for (int i = 0; i < nedges; ++i) {
            int src = ATNSimulator.toInt(data[p]);
            int trg = ATNSimulator.toInt(data[p + 1]);
            int ttype = ATNSimulator.toInt(data[p + 2]);
            int arg1 = ATNSimulator.toInt(data[p + 3]);
            int arg2 = ATNSimulator.toInt(data[p + 4]);
            int arg3 = ATNSimulator.toInt(data[p + 5]);
            Transition trans = ATNSimulator.edgeFactory(atn, ttype, src, trg, arg1, arg2, arg3, sets);
            ATNState srcState = atn.states.get(src);
            srcState.addTransition(trans);
            p += 6;
        }
        for (ATNState state : atn.states) {
            for (int i = 0; i < state.getNumberOfTransitions(); ++i) {
                Transition t = state.transition(i);
                if (!(t instanceof RuleTransition)) continue;
                RuleTransition ruleTransition = (RuleTransition)t;
                atn.ruleToStopState[ruleTransition.target.ruleIndex].addTransition(new EpsilonTransition(ruleTransition.followState));
            }
        }
        for (ATNState state : atn.states) {
            ATNState target;
            int i;
            ATNState loopbackState;
            if (state instanceof BlockStartState) {
                if (((BlockStartState)state).endState == null) {
                    throw new IllegalStateException();
                }
                if (((BlockStartState)state).endState.startState != null) {
                    throw new IllegalStateException();
                }
                ((BlockStartState)state).endState.startState = (BlockStartState)state;
            }
            if (state instanceof PlusLoopbackState) {
                loopbackState = (PlusLoopbackState)state;
                for (i = 0; i < loopbackState.getNumberOfTransitions(); ++i) {
                    target = loopbackState.transition((int)i).target;
                    if (!(target instanceof PlusBlockStartState)) continue;
                    ((PlusBlockStartState)target).loopBackState = loopbackState;
                }
                continue;
            }
            if (!(state instanceof StarLoopbackState)) continue;
            loopbackState = (StarLoopbackState)state;
            for (i = 0; i < loopbackState.getNumberOfTransitions(); ++i) {
                target = loopbackState.transition((int)i).target;
                if (!(target instanceof StarLoopEntryState)) continue;
                ((StarLoopEntryState)target).loopBackState = loopbackState;
            }
        }
        int ndecisions = ATNSimulator.toInt(data[p++]);
        for (int i = 1; i <= ndecisions; ++i) {
            int s = ATNSimulator.toInt(data[p++]);
            DecisionState decState = (DecisionState)atn.states.get(s);
            atn.decisionToState.add(decState);
            decState.decision = i - 1;
        }
        ATNSimulator.verifyATN(atn);
        return atn;
    }

    private static void verifyATN(ATN atn) {
        for (ATNState state : atn.states) {
            if (state == null) continue;
            ATNSimulator.checkCondition(state.onlyHasEpsilonTransitions() || state.getNumberOfTransitions() <= 1);
            if (state instanceof PlusBlockStartState) {
                ATNSimulator.checkCondition(((PlusBlockStartState)state).loopBackState != null);
            }
            if (state instanceof StarLoopEntryState) {
                StarLoopEntryState starLoopEntryState = (StarLoopEntryState)state;
                ATNSimulator.checkCondition(starLoopEntryState.loopBackState != null);
                ATNSimulator.checkCondition(starLoopEntryState.getNumberOfTransitions() == 2);
                if (starLoopEntryState.transition((int)0).target instanceof StarBlockStartState) {
                    ATNSimulator.checkCondition(starLoopEntryState.transition((int)1).target instanceof LoopEndState);
                    ATNSimulator.checkCondition(!starLoopEntryState.nonGreedy);
                } else if (starLoopEntryState.transition((int)0).target instanceof LoopEndState) {
                    ATNSimulator.checkCondition(starLoopEntryState.transition((int)1).target instanceof StarBlockStartState);
                    ATNSimulator.checkCondition(starLoopEntryState.nonGreedy);
                } else {
                    throw new IllegalStateException();
                }
            }
            if (state instanceof StarLoopbackState) {
                ATNSimulator.checkCondition(state.getNumberOfTransitions() == 1);
                ATNSimulator.checkCondition(state.transition((int)0).target instanceof StarLoopEntryState);
            }
            if (state instanceof LoopEndState) {
                ATNSimulator.checkCondition(((LoopEndState)state).loopBackState != null);
            }
            if (state instanceof RuleStartState) {
                ATNSimulator.checkCondition(((RuleStartState)state).stopState != null);
            }
            if (state instanceof BlockStartState) {
                ATNSimulator.checkCondition(((BlockStartState)state).endState != null);
            }
            if (state instanceof BlockEndState) {
                ATNSimulator.checkCondition(((BlockEndState)state).startState != null);
            }
            if (state instanceof DecisionState) {
                DecisionState decisionState = (DecisionState)state;
                ATNSimulator.checkCondition(decisionState.getNumberOfTransitions() <= 1 || decisionState.decision >= 0);
                continue;
            }
            ATNSimulator.checkCondition(state.getNumberOfTransitions() <= 1 || state instanceof RuleStopState);
        }
    }

    public static void checkCondition(boolean condition) {
        ATNSimulator.checkCondition(condition, null);
    }

    public static void checkCondition(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }

    public static int toInt(char c) {
        return c;
    }

    public static int toInt32(char[] data, int offset) {
        return data[offset] | data[offset + 1] << 16;
    }

    public static long toLong(char[] data, int offset) {
        long lowOrder = (long)ATNSimulator.toInt32(data, offset) & 0xFFFFFFFFL;
        return lowOrder | (long)ATNSimulator.toInt32(data, offset + 2) << 32;
    }

    public static UUID toUUID(char[] data, int offset) {
        long leastSigBits = ATNSimulator.toLong(data, offset);
        long mostSigBits = ATNSimulator.toLong(data, offset + 4);
        return new UUID(mostSigBits, leastSigBits);
    }

    @NotNull
    public static Transition edgeFactory(@NotNull ATN atn, int type, int src, int trg, int arg1, int arg2, int arg3, List<IntervalSet> sets) {
        ATNState target = atn.states.get(trg);
        switch (type) {
            case 1: {
                return new EpsilonTransition(target);
            }
            case 2: {
                if (arg3 != 0) {
                    return new RangeTransition(target, -1, arg2);
                }
                return new RangeTransition(target, arg1, arg2);
            }
            case 3: {
                RuleTransition rt = new RuleTransition((RuleStartState)atn.states.get(arg1), arg2, target);
                return rt;
            }
            case 4: {
                PredicateTransition pt = new PredicateTransition(target, arg1, arg2, arg3 != 0);
                return pt;
            }
            case 5: {
                if (arg3 != 0) {
                    return new AtomTransition(target, -1);
                }
                return new AtomTransition(target, arg1);
            }
            case 6: {
                ActionTransition a = new ActionTransition(target, arg1, arg2, arg3 != 0);
                return a;
            }
            case 7: {
                return new SetTransition(target, sets.get(arg1));
            }
            case 8: {
                return new NotSetTransition(target, sets.get(arg1));
            }
            case 9: {
                return new WildcardTransition(target);
            }
        }
        throw new IllegalArgumentException("The specified transition type is not valid.");
    }

    public static ATNState stateFactory(int type, int ruleIndex) {
        ATNState s;
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                s = new BasicState();
                break;
            }
            case 2: {
                s = new RuleStartState();
                break;
            }
            case 3: {
                s = new BasicBlockStartState();
                break;
            }
            case 4: {
                s = new PlusBlockStartState();
                break;
            }
            case 5: {
                s = new StarBlockStartState();
                break;
            }
            case 6: {
                s = new TokensStartState();
                break;
            }
            case 7: {
                s = new RuleStopState();
                break;
            }
            case 8: {
                s = new BlockEndState();
                break;
            }
            case 9: {
                s = new StarLoopbackState();
                break;
            }
            case 10: {
                s = new StarLoopEntryState();
                break;
            }
            case 11: {
                s = new PlusLoopbackState();
                break;
            }
            case 12: {
                s = new LoopEndState();
                break;
            }
            default: {
                String message = String.format(Locale.getDefault(), "The specified state type %d is not valid.", type);
                throw new IllegalArgumentException(message);
            }
        }
        s.ruleIndex = ruleIndex;
        return s;
    }

    static {
        ATNSimulator.ERROR.stateNumber = Integer.MAX_VALUE;
    }
}

