package models;

import java.util.*;

public class Produto {
  public long codigo;
  public String nome;
  public String descricao;
  public Produto(){}
  public Produto(long codigo, String nome, String descricao){
  	this.codigo = codigo;
  	this.nome = nome;
  	this.descricao = descricao;
  }
  @Override
  public String toString(){
  	return codigo + " - " + nome;
  }

  private static Set<Produto> produtos = new HashSet<Produto>();
  static {
    produtos.add(new Produto(1l,"Caderno","Caderno 10 matérias"));
    produtos.add(new Produto(2l,"Lapis","Lápis Grafite"));
    produtos.add(new Produto(3l,"Regua","Lápis Grafite"));
    produtos.add(new Produto(4l,"Lapis","Lápis Grafite"));
  }

  public static Set<Produto> todos(){
  	return new HashSet<Produto>(produtos);
  }

  public static Produto procurar(long cod){
  	for (Produto candidato : produtos) {
      if (candidato.codigo==cod) {
        return candidato;
      }
    }
    return null;
  }

  public static void inserir(Produto produto){
    produtos.add(produto);
  }
}