package controllers;

import play.*;
import play.mvc.*;

import views.html.produtos.*;

import models.*;

import java.util.*;
import play.data.*;

public class Produtos extends Controller {
  
  public static Result listar(){ 
  	Set<Produto> produtos = Produto.todos();
  	return ok(lista.render(produtos));
  }
  
  public static Result mostrar(long cod){
    Produto produto = Produto.procurar(cod);
    if (produto==null) 
      return ok("Produto não encontrado");
  	return ok(mostra.render(produto));
  }

  private static Form<Produto> formProduto = new Form<Produto>(Produto.class);

  public static Result emBranco(){
    return ok(novo.render(formProduto));
  }
  public static Result inserir(){ 
    Form<Produto> novoProduto = formProduto.bindFromRequest();
    Produto produto = novoProduto.get();
    Produto.inserir(produto);
    return ok("Produto Inserido");
  }
  public static Result remover(long cod){ return TODO;}

  public static Result editar(long cod){ return TODO;}
  public static Result atualizar(long cod){ return TODO;}
}