package models;

import java.math.BigDecimal;
import java.util.Date;

public class Veiculo extends Model {
	public final String placa;
	public final String chassi;
	public final byte[] foto;
	public final Date dataCompra; //data em que a loja adquiriu o ve�culo
	public final BigDecimal precoCompra;
	public final Date dataVenda; //data em que a loja vendeu o ve�culo
	public final BigDecimal precoVenda;
	public final Modelo modelo;

	public boolean isVendido(){
		return (dataVenda != null || precoVenda != null);
	}
	
	public Veiculo venda(BigDecimal precoVenda, Date dataVenda) {
		return new Veiculo(id, placa, chassi, foto, dataCompra, precoCompra, dataVenda, precoVenda, modelo);
	}
	public Veiculo() {
		this(null,null,null,null,null,null,null,null,null);
	}

	public Veiculo(Integer id, String placa, String chassi, byte[] foto,
      Date dataCompra, BigDecimal precoCompra, Date dataVenda,
      BigDecimal precoVenda, Modelo modelo) {
	  super(id);
	  this.placa = placa;
	  this.chassi = chassi;
	  this.foto = foto;
	  this.dataCompra = dataCompra;
	  this.precoCompra = precoCompra;
	  this.dataVenda = dataVenda;
	  this.precoVenda = precoVenda;
	  this.modelo = modelo;
  }
}