package models;

import java.math.BigDecimal;
import java.util.Date;

import models.dao.DAOVeiculo;


public class RepositorioVeiculo extends Repositorio<Veiculo> {

	public RepositorioVeiculo(DAOVeiculo dao) {
		super(dao);
	}

	@Override
	public Integer inserir(Veiculo veiculo) {
		if (veiculo.isVendido()) {
			throw new ModeloException("No cadastro do veículo os campos data venda "
			    + "e preço venda devem ser nulos");
		}
		return super.inserir(veiculo);
	}

	@Override
	public void excluir(Veiculo veiculo) {
		if (veiculo.isVendido()) {
			throw new ModeloException("Um veículo vendido não pode ser excluído");
		}
		super.excluir(veiculo);
	}

	@Override
	public void atualizar(Veiculo veiculo) {
		if (veiculo.isVendido()) {
			throw new ModeloException("Um veículo vendido não pode ser alterado");
		}
		super.atualizar(veiculo);
	}

	public void vender(Veiculo veiculo, Date dataVenda, BigDecimal precoVenda) {
		if (veiculo.isVendido()) {
			throw new ModeloException("Veículo já vendido");
		}
		if (dataVenda.before(veiculo.dataCompra)) {
			throw new ModeloException(
			    "Data de venda não pode ser anterior a data de compra.");
		}
		Veiculo vendido = veiculo.venda(precoVenda, dataVenda);
		super.atualizar(vendido);
	}
}