package controllers;

import java.util.List;

import models.Fabricante;
import models.RepositorioFabricante;
import models.dao.DAOFabricante;
import play.data.Form;
import play.mvc.Controller;
import play.mvc.Result;
import views.html.Fabricantes.*;

public class Fabricantes extends Controller {
	
	private static Form<Fabricante> formFabricante = new Form<Fabricante>(Fabricante.class);
	private static RepositorioFabricante repFabricante = new RepositorioFabricante(new DAOFabricante());
	
	public static Result emBranco() {
		return ok(emBranco.render(formFabricante)); 
	}
	
	public static Result inserir() {
    Form<Fabricante> novoFabricante = formFabricante.bindFromRequest();
    Fabricante fabricante = novoFabricante.get();
    repFabricante.inserir(fabricante);
    return ok("Produto Inserido");
	}
	public static Result listar() {
		List<Fabricante> fabricantes = repFabricante.todos();
		// reutrn ok(listar.render(fabricantes));
		return TODO;
	}
	public static Result mostrar(Integer id) {
		Fabricante fabricante = repFabricante.procurar(id);
		if (fabricante==null) return notFound("Fabricante não encontrado");
		// return ok(mostrar.render(fabricante));
		return TODO;
	}
	public static Result editar(Integer id) {
		Fabricante fabricante = repFabricante.procurar(id);
		if (fabricante==null) return notFound("Fabricante não encontrado");
		// return ok(editar.render(fabricante));		
		return TODO;
	}
	public static Result atualizar(Integer id) {
		return TODO;
	}
	public static Result remover(Integer id) {
		return TODO;
	}
}
