package models;

import java.util.List;

import models.dao.DAO;



/**
 * Classe com m�todos para obten��o, inser��o e atualiza��o de fabricantes.
 */
public class Repositorio<T>{
	
	protected final DAO<T> dao;
	
	protected Repositorio(DAO<T> dao){
		this.dao = dao;
	}
	
	public Integer inserir(T obj){
		return dao.inserir(obj);
	}
	
	public void atualizar(T obj){
		dao.atualizar(obj);
	}
	
	public void excluir(T obj){
		dao.excluir(obj);
	}
	
	public List<T> todos(){
		return dao.todos();
	}
}
