package models;

import java.util.List;

import models.dao.DAOFabricante;

/**
 * Classe com métodos para obtenção, inserção e atualização de fabricantes.
 */
public class RepositorioFabricante extends Repositorio<Fabricante> {

	public RepositorioFabricante(DAOFabricante dao) {
		super(dao);
	}

	public Fabricante procurar(Integer id) {
		List<Fabricante> fabricantes = dao.todos();

		for (Fabricante fabricante : fabricantes) {
			if (fabricante.id == id) {
				return fabricante;
			}
		}
		return null;
	}
}