// @SOURCE:C:/Users/Lucena/Documents/projetos/Veiculos/conf/routes
// @HASH:bf087a22b6c62fa685590c9b414bbda7d4187b5c
// @DATE:Fri Feb 01 12:14:18 GMT-03:00 2013

import Routes.{prefix => _prefix, defaultPrefix => _defaultPrefix}
import play.core._
import play.core.Router._
import play.core.j._

import play.api.mvc._
import play.libs.F

import Router.queryString


// @LINE:21
// @LINE:18
// @LINE:16
// @LINE:15
// @LINE:13
// @LINE:12
// @LINE:10
// @LINE:9
// @LINE:6
package controllers {

// @LINE:18
// @LINE:16
// @LINE:15
// @LINE:13
// @LINE:12
// @LINE:10
// @LINE:9
class ReverseFabricantes {
    

// @LINE:10
def inserir(): Call = {
   Call("POST", _prefix + { _defaultPrefix } + "fabricante")
}
                                                

// @LINE:9
def emBranco(): Call = {
   Call("GET", _prefix + { _defaultPrefix } + "fabricante/novo")
}
                                                

// @LINE:16
def atualizar(cod:Int): Call = {
   Call("POST", _prefix + { _defaultPrefix } + "fabricante/" + implicitly[PathBindable[Int]].unbind("cod", cod) + "/editar")
}
                                                

// @LINE:15
def editar(cod:Int): Call = {
   Call("GET", _prefix + { _defaultPrefix } + "fabricante/" + implicitly[PathBindable[Int]].unbind("cod", cod) + "/editar")
}
                                                

// @LINE:18
def remover(cod:Int): Call = {
   Call("POST", _prefix + { _defaultPrefix } + "fabricante/" + implicitly[PathBindable[Int]].unbind("cod", cod))
}
                                                

// @LINE:12
def listar(): Call = {
   Call("GET", _prefix + { _defaultPrefix } + "fabricante")
}
                                                

// @LINE:13
def mostrar(cod:Int): Call = {
   Call("GET", _prefix + { _defaultPrefix } + "fabricante/" + implicitly[PathBindable[Int]].unbind("cod", cod))
}
                                                
    
}
                          

// @LINE:6
class ReverseApplication {
    

// @LINE:6
def index(): Call = {
   Call("GET", _prefix)
}
                                                
    
}
                          

// @LINE:21
class ReverseAssets {
    

// @LINE:21
def at(file:String): Call = {
   Call("GET", _prefix + { _defaultPrefix } + "assets/" + implicitly[PathBindable[String]].unbind("file", file))
}
                                                
    
}
                          
}
                  


// @LINE:21
// @LINE:18
// @LINE:16
// @LINE:15
// @LINE:13
// @LINE:12
// @LINE:10
// @LINE:9
// @LINE:6
package controllers.javascript {

// @LINE:18
// @LINE:16
// @LINE:15
// @LINE:13
// @LINE:12
// @LINE:10
// @LINE:9
class ReverseFabricantes {
    

// @LINE:10
def inserir : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Fabricantes.inserir",
   """
      function() {
      return _wA({method:"POST", url:"""" + _prefix + { _defaultPrefix } + """" + "fabricante"})
      }
   """
)
                        

// @LINE:9
def emBranco : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Fabricantes.emBranco",
   """
      function() {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "fabricante/novo"})
      }
   """
)
                        

// @LINE:16
def atualizar : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Fabricantes.atualizar",
   """
      function(cod) {
      return _wA({method:"POST", url:"""" + _prefix + { _defaultPrefix } + """" + "fabricante/" + (""" + implicitly[PathBindable[Int]].javascriptUnbind + """)("cod", cod) + "/editar"})
      }
   """
)
                        

// @LINE:15
def editar : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Fabricantes.editar",
   """
      function(cod) {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "fabricante/" + (""" + implicitly[PathBindable[Int]].javascriptUnbind + """)("cod", cod) + "/editar"})
      }
   """
)
                        

// @LINE:18
def remover : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Fabricantes.remover",
   """
      function(cod) {
      return _wA({method:"POST", url:"""" + _prefix + { _defaultPrefix } + """" + "fabricante/" + (""" + implicitly[PathBindable[Int]].javascriptUnbind + """)("cod", cod)})
      }
   """
)
                        

// @LINE:12
def listar : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Fabricantes.listar",
   """
      function() {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "fabricante"})
      }
   """
)
                        

// @LINE:13
def mostrar : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Fabricantes.mostrar",
   """
      function(cod) {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "fabricante/" + (""" + implicitly[PathBindable[Int]].javascriptUnbind + """)("cod", cod)})
      }
   """
)
                        
    
}
              

// @LINE:6
class ReverseApplication {
    

// @LINE:6
def index : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Application.index",
   """
      function() {
      return _wA({method:"GET", url:"""" + _prefix + """"})
      }
   """
)
                        
    
}
              

// @LINE:21
class ReverseAssets {
    

// @LINE:21
def at : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Assets.at",
   """
      function(file) {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "assets/" + (""" + implicitly[PathBindable[String]].javascriptUnbind + """)("file", file)})
      }
   """
)
                        
    
}
              
}
        


// @LINE:21
// @LINE:18
// @LINE:16
// @LINE:15
// @LINE:13
// @LINE:12
// @LINE:10
// @LINE:9
// @LINE:6
package controllers.ref {

// @LINE:18
// @LINE:16
// @LINE:15
// @LINE:13
// @LINE:12
// @LINE:10
// @LINE:9
class ReverseFabricantes {
    

// @LINE:10
def inserir(): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Fabricantes.inserir(), HandlerDef(this, "controllers.Fabricantes", "inserir", Seq(), "POST", """""", _prefix + """fabricante""")
)
                      

// @LINE:9
def emBranco(): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Fabricantes.emBranco(), HandlerDef(this, "controllers.Fabricantes", "emBranco", Seq(), "GET", """ Criar""", _prefix + """fabricante/novo""")
)
                      

// @LINE:16
def atualizar(cod:Int): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Fabricantes.atualizar(cod), HandlerDef(this, "controllers.Fabricantes", "atualizar", Seq(classOf[Int]), "POST", """""", _prefix + """fabricante/$cod<[^/]+>/editar""")
)
                      

// @LINE:15
def editar(cod:Int): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Fabricantes.editar(cod), HandlerDef(this, "controllers.Fabricantes", "editar", Seq(classOf[Int]), "GET", """ Atualizar""", _prefix + """fabricante/$cod<[^/]+>/editar""")
)
                      

// @LINE:18
def remover(cod:Int): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Fabricantes.remover(cod), HandlerDef(this, "controllers.Fabricantes", "remover", Seq(classOf[Int]), "POST", """ Excluir""", _prefix + """fabricante/$cod<[^/]+>""")
)
                      

// @LINE:12
def listar(): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Fabricantes.listar(), HandlerDef(this, "controllers.Fabricantes", "listar", Seq(), "GET", """ Buscar""", _prefix + """fabricante""")
)
                      

// @LINE:13
def mostrar(cod:Int): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Fabricantes.mostrar(cod), HandlerDef(this, "controllers.Fabricantes", "mostrar", Seq(classOf[Int]), "GET", """""", _prefix + """fabricante/$cod<[^/]+>""")
)
                      
    
}
                          

// @LINE:6
class ReverseApplication {
    

// @LINE:6
def index(): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Application.index(), HandlerDef(this, "controllers.Application", "index", Seq(), "GET", """ Home page""", _prefix + """""")
)
                      
    
}
                          

// @LINE:21
class ReverseAssets {
    

// @LINE:21
def at(path:String, file:String): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Assets.at(path, file), HandlerDef(this, "controllers.Assets", "at", Seq(classOf[String], classOf[String]), "GET", """ Map static resources from the /public folder to the /assets URL path""", _prefix + """assets/$file<.+>""")
)
                      
    
}
                          
}
                  
      