import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;
import java.util.StringTokenizer;

/*
 * A class that reads input lines from the user.
 * Input is filtered via getCommand for valid commands.
 *
 * @author  Michael Kolling and David J. Barnes
 * @version 2002.06.11
 */

public class Parser 
{
    // Hold all valid command words.
    private CommandWords commands;

    public Parser() 
    {
        commands = new CommandWords();
    }

    /**
     * Read the next command from the user.
     * The returned command will be valid.
     * @return A valid command.
     */
    public String getCommand() 
    {
        String command = null;
        do {
            String word1;
            // Print a prompt.
            System.out.print("> ");
            
            String inputLine = readLine();
            // Break up the line in order to pick up the first word.
            StringTokenizer tokenizer = new StringTokenizer(inputLine);    
            if(tokenizer.hasMoreTokens()) {
                word1 = tokenizer.nextToken();
                if(commands.isCommand(word1)) {
                    command = word1;
                }
                else{
                    System.out.println("Unrecognized command: " + word1);
                    System.out.print("Valid commands are: ");
                    commands.showAll();
                }
            }
        } while(command == null);
    
        return command;
    }
    
    /**
     * Try to read a single line from the user.
     * Return a blank line on any input error.
     * @return The line.
     */
    public String readLine()
    {
        try {
            BufferedReader reader = 
                new BufferedReader(new InputStreamReader(System.in));
            return reader.readLine();
        }
        catch(IOException exc) {
            System.out.println ("There was an error during reading: "
                                + exc.getMessage());
            return "";
        }
    }

    /**
     * Print out a list of valid command words.
     */
    public void showCommands()
    {
        commands.showAll();
    }
}
