/*
 * This class holds an enumeration of all command words known
 * to the program.
 *
 * @author  Michael Kolling and David J. Barnes
 * @version 2002.06.11
 */

public class CommandWords
{
    // a constant array that holds all valid command words
    private static final String validCommands[] = {
        "add", "search", "list", "help", "quit",
    };

    /**
     */
    public CommandWords()
    {
    }

    /**
     * Check whether a given String is a valid command word. 
     * Return true if it is, false if it isn't.
     */
    public boolean isCommand(String aString)
    {
        if(aString != null){
            for(int i = 0; i < validCommands.length; i++) {
                if(validCommands[i].equals(aString))
                    return true;
            }
        }
        // if we get here, the string was not found in the commands
        return false;
    }

    /*
     * Print all valid commands to System.out.
     */
    public void showAll() 
    {
        for(int i = 0; i < validCommands.length; i++) {
            System.out.print(validCommands[i] + "  ");
        }
        System.out.println();
    }
}
