
/**
 * Simulate passengers requesting rides from a taxi company.
 * Passengers should be generated at random intervals.
 * 
 * @author David J. Barnes and Michael Kolling
 * @version 2002.06.20
 */
public class PassengerSource
{
    private TaxiCompany company;

    /**
     * Constructor for objects of class PassengerSource.
     * @param company The company to be used. Must not be null.
     * @throws NullPointerException if company is null.
     */
    public PassengerSource(TaxiCompany company)
    {
        if(company == null) {
            throw new NullPointerException("company");
        }
        this.company = company;
    }

    /**
     * Have the source generate a new passenger and
     * request a pickup from the company.
     * @return true If the request succeeds, false otherwise.
     */
    public boolean requestPickup()
    {
        Passenger passenger = createPassenger();
        return company.requestPickup(passenger);
    }

    /**
     * Create a new passenger.
     * @return The created passenger.
     */
    private Passenger createPassenger()
    {
        return new Passenger(new Location(), new Location());
    }
}
