/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package schedsim;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.Timer;

/**
 *
 * @author tadeu
 */
public class SchedSimUI extends javax.swing.JFrame {
    private final static String ARQUIVO = "processos.txt";
    private final static Charset ENCODING = StandardCharsets.UTF_8;
    private final static int DELAY = 500;
    private ArrayList<Processo> filaPronto, filaTerminado;
    Timer schedulerTimer;
    private int tempoTotal = 0;
    /**
     * Creates new form SchedSimUI
     */
    public SchedSimUI() {
        filaPronto = new ArrayList<>();
        filaTerminado = new ArrayList<>();
        schedulerTimer = new Timer(DELAY, atualizaCPU);
        initComponents();
    }
    //Metodo executado pelo Timer a cada DELAY ms
    private final ActionListener atualizaCPU = new ActionListener(){
        @Override
        public void actionPerformed(ActionEvent e){
            Processo processoAtual;            
            if (!filaPronto.isEmpty()){
                tempoTotal++;
                processoAtual = filaPronto.get(0);
                if(processoAtual.getTempoRestante() > 0){
                    jLabelCPU.setText(processoAtual.getNome());
                    processoAtual.decTempoRestante();
                    
                    //atualizar os tempos de espera dos outros processos
                    Processo umProcesso;
                    Iterator itr = filaPronto.iterator();
                    //pular o processo em execução no momento
                    itr.next();
                    while (itr.hasNext()){
                        umProcesso = ((Processo) itr.next());
                        umProcesso.incTempoEspera();
                    }
                    
                }else{
                    //se o processo não precisa mais executar tempoRestante == 0
                    filaTerminado.add(filaPronto.get(0));
                    filaPronto.remove(0);
                }                
                jTxtAreaFilaPronto.setText(filaPronto.toString());
                jLabelTempoAtual.setText("Tempo AtuaL: "+Integer.toString(tempoTotal));
            }else{
                JOptionPane.showMessageDialog(null, "Fila de prontos vazia");
                jTxtAreaFilaPronto.setText("Execução Terminada. ");
                jTxtAreaFilaPronto.append(filaTerminado.toString());
                schedulerTimer.stop();                
                jButtonExec.setEnabled(true);
            }            
        }
    };
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jRadioButFIFO = new javax.swing.JRadioButton();
        jRadioButSJF = new javax.swing.JRadioButton();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTxtAreaFilaPronto = new javax.swing.JTextArea();
        jLabel2 = new javax.swing.JLabel();
        jLabelCPU = new javax.swing.JLabel();
        jLabelTempoAtual = new javax.swing.JLabel();
        jButtonCarregar = new javax.swing.JButton();
        jButtonExec = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        buttonGroup1.add(jRadioButFIFO);
        jRadioButFIFO.setSelected(true);
        jRadioButFIFO.setText("FIFO");

        buttonGroup1.add(jRadioButSJF);
        jRadioButSJF.setText("SJF");

        jLabel1.setFont(new java.awt.Font("Lucida Grande", 1, 13)); // NOI18N
        jLabel1.setText("Fila de Pronto");

        jTxtAreaFilaPronto.setColumns(20);
        jTxtAreaFilaPronto.setRows(5);
        jTxtAreaFilaPronto.setEnabled(false);
        jScrollPane1.setViewportView(jTxtAreaFilaPronto);

        jLabel2.setFont(new java.awt.Font("Lucida Grande", 1, 13)); // NOI18N
        jLabel2.setText("CPU");

        jLabelCPU.setForeground(new java.awt.Color(255, 0, 0));
        jLabelCPU.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabelCPU.setText("-IDLE-");
        jLabelCPU.setBorder(new javax.swing.border.LineBorder(new java.awt.Color(255, 0, 51), 1, true));
        jLabelCPU.setName("jLabelCPU"); // NOI18N

        jLabelTempoAtual.setText("Tempo Atual:");

        jButtonCarregar.setText("Carregar Processos");
        jButtonCarregar.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jButtonCarregarMouseClicked(evt);
            }
        });

        jButtonExec.setText("Executar");
        jButtonExec.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jButtonExecMouseClicked(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(28, 28, 28)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jRadioButFIFO)
                            .addComponent(jLabel1)
                            .addComponent(jRadioButSJF)
                            .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 331, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 41, Short.MAX_VALUE)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jLabelTempoAtual)
                                .addGap(58, 58, 58))
                            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                    .addComponent(jLabelCPU, javax.swing.GroupLayout.PREFERRED_SIZE, 73, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addGap(30, 30, 30))
                                .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                    .addComponent(jLabel2)
                                    .addGap(56, 56, 56)))))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jButtonCarregar)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jButtonExec)
                        .addGap(58, 58, 58))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(17, 17, 17)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jRadioButFIFO)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jRadioButSJF)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jLabel1))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabelCPU, javax.swing.GroupLayout.PREFERRED_SIZE, 58, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(19, 19, 19)
                        .addComponent(jLabelTempoAtual)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 166, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)))
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonExec)
                    .addComponent(jButtonCarregar))
                .addGap(32, 32, 32))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonCarregarMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButtonCarregarMouseClicked
        Path path = Paths.get(ARQUIVO);
        //carrega o conteudo de ARQUIVO em um ArrayList
        List <String> texto = new ArrayList<>();
        try {
            texto = Files.readAllLines(path, ENCODING);
        } catch (IOException ex) {
            Logger.getLogger(SchedSimUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        //Limpar as filas para uma nova execução
        filaPronto.clear();
        filaTerminado.clear();
        tempoTotal = 0;
        
        //Cria os objetos processo e adiciona em filaPronto
        Iterator itr = texto.iterator();
        int tempo, cont = 0;
        String nomeProcesso;        
        while(itr.hasNext()){         
            tempo = Integer.parseInt(itr.next().toString());
            //o nome do processo é uma letra de A a Z
            nomeProcesso = Character.toString((char)(65+cont));
            filaPronto.add(new Processo(tempo,nomeProcesso));
            cont++;
        }
        
        //Exibe no painel a fila de prontos recém-carregada
        jTxtAreaFilaPronto.setText(filaPronto.toString());
    }//GEN-LAST:event_jButtonCarregarMouseClicked

    private void jButtonExecMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButtonExecMouseClicked
        if (buttonGroup1.getSelection().equals(jRadioButSJF.getModel())){  
            //ordenar a fila de prontos
            Collections.sort(filaPronto, new Comparator<Processo>(){
                @Override
                public int compare(Processo p1, Processo p2){
                    //compara dois processos de acordo com o tempo total 
                    //necessario para executar
                    if (p1.getTempoNecessario() == p2.getTempoNecessario())
                        return 0;
                    else 
                        if (p1.getTempoNecessario() > p2.getTempoNecessario())
                            return 1;
                        else
                            return -1;
                }
            }
            );
            jTxtAreaFilaPronto.setText(filaPronto.toString());
        } else {
            //Para o FIFO não é necessário ordenar
        }
        tempoTotal = 0;
        schedulerTimer.start();
        jButtonExec.setEnabled(false);
    }//GEN-LAST:event_jButtonExecMouseClicked

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(SchedSimUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(SchedSimUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(SchedSimUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(SchedSimUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            @Override
            public void run() {
                new SchedSimUI().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton jButtonCarregar;
    private javax.swing.JButton jButtonExec;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabelCPU;
    private javax.swing.JLabel jLabelTempoAtual;
    private javax.swing.JRadioButton jRadioButFIFO;
    private javax.swing.JRadioButton jRadioButSJF;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea jTxtAreaFilaPronto;
    // End of variables declaration//GEN-END:variables
}
